// CPDFCreactiveX.h  : Declaration of ActiveX Control wrapper class(es) created by Microsoft Visual C++

#pragma once

/////////////////////////////////////////////////////////////////////////////
// CPDFCreactiveX

class CPDFCreactiveX : public CWnd
{
protected:
	DECLARE_DYNCREATE(CPDFCreactiveX)
public:
	CLSID const& GetClsid()
	{
		static CLSID const clsid
			= { 0x2FE33B61, 0x2B6A, 0x4685,{ 0x97, 0x64, 0x6F, 0x9, 0xC3, 0xC1, 0x82, 0x2F } };
		return clsid;
	}
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle,
						const RECT& rect, CWnd* pParentWnd, UINT nID, 
						CCreateContext* pContext = NULL)
	{ 
		return CreateControl(GetClsid(), lpszWindowName, dwStyle, rect, pParentWnd, nID); 
	}

    BOOL Create(LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, 
				UINT nID, CFile* pPersist = NULL, BOOL bStorage = FALSE,
				BSTR bstrLicKey = NULL)
	{ 
		return CreateControl(GetClsid(), lpszWindowName, dwStyle, rect, pParentWnd, nID,
		pPersist, bStorage, bstrLicKey); 
	}

// Attributes
public:

// Operations
public:

	short get_RulerSize()
	{
		short result;
		InvokeHelper(0x1, DISPATCH_PROPERTYGET, VT_I2, (void*)&result, NULL);
		return result;
	}
	void put_RulerSize(short newValue)
	{
		static BYTE parms[] = VTS_I2 ;
		InvokeHelper(0x1, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void ScrollWindow(long HorzScroll, long VertScroll)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x2, DISPATCH_METHOD, VT_EMPTY, NULL, parms, HorzScroll, VertScroll);
	}
	long get_ReportView()
	{
		long result;
		InvokeHelper(0x3, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ReportView(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x3, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void RedrawObject(LPCTSTR Object)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x4, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object);
	}
	long get_ReportState()
	{
		long result;
		InvokeHelper(0x5, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ReportState(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x5, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_ZoomFactor()
	{
		long result;
		InvokeHelper(0x6, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ZoomFactor(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x6, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void InitTable(long RowCount, long ColCount)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x7, DISPATCH_METHOD, VT_EMPTY, NULL, parms, RowCount, ColCount);
	}
	long get_GridView()
	{
		long result;
		InvokeHelper(0x8, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_GridView(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x8, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void Refresh()
	{
		InvokeHelper(0x9, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	long get_AutoRefresh()
	{
		long result;
		InvokeHelper(0xa, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_AutoRefresh(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0xa, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_FitToParent()
	{
		long result;
		InvokeHelper(0xb, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_FitToParent(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0xb, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void InsertObject(long ObjectType)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0xc, DISPATCH_METHOD, VT_EMPTY, NULL, parms, ObjectType);
	}
	long UndoLevels()
	{
		long result;
		InvokeHelper(0xd, DISPATCH_METHOD, VT_I4, (void*)&result, NULL);
		return result;
	}
	long RedoLevels()
	{
		long result;
		InvokeHelper(0xe, DISPATCH_METHOD, VT_I4, (void*)&result, NULL);
		return result;
	}
	void Undo()
	{
		InvokeHelper(0xf, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void Redo()
	{
		InvokeHelper(0x10, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void DeleteObject(LPCTSTR Object, long CanUndo)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x11, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object, CanUndo);
	}
	long ActiveTool()
	{
		long result;
		InvokeHelper(0x12, DISPATCH_METHOD, VT_I4, (void*)&result, NULL);
		return result;
	}
	void DoCommandTool(long Id)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x13, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Id);
	}
	long UpdateCommandTool(long Id)
	{
		long result;
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x14, DISPATCH_METHOD, VT_I4, (void*)&result, parms, Id);
		return result;
	}
	void RedrawRect(long left, long top, long right, long bottom)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x15, DISPATCH_METHOD, VT_EMPTY, NULL, parms, left, top, right, bottom);
	}
	void Save(LPCTSTR FileName, long SaveOption)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x16, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, SaveOption);
	}
	long Open(LPCTSTR FileName, LPCTSTR Password)
	{
		long result;
		static BYTE parms[] = VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x17, DISPATCH_METHOD, VT_I4, (void*)&result, parms, FileName, Password);
		return result;
	}
	long get_MinimumGap()
	{
		long result;
		InvokeHelper(0x18, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_MinimumGap(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x18, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_HorzScrollBar()
	{
		long result;
		InvokeHelper(0x19, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_HorzScrollBar(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x19, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_VertScrollBar()
	{
		long result;
		InvokeHelper(0x1a, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_VertScrollBar(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x1a, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_ShowMargins()
	{
		long result;
		InvokeHelper(0x1b, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ShowMargins(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x1b, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void InitBlank()
	{
		InvokeHelper(0x1c, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void InitReport()
	{
		InvokeHelper(0x1d, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void CreateSection(short Groups)
	{
		static BYTE parms[] = VTS_I2 ;
		InvokeHelper(0x1e, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Groups);
	}
	void Print(LPCTSTR PrinterName, long Prompt)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x1f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PrinterName, Prompt);
	}
	CString get_DataSource()
	{
		CString result;
		InvokeHelper(0x20, DISPATCH_PROPERTYGET, VT_BSTR, (void*)&result, NULL);
		return result;
	}
	void put_DataSource(LPCTSTR newValue)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x20, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	LPUNKNOWN get_DataSourceEx()
	{
		LPUNKNOWN result;
		InvokeHelper(0x21, DISPATCH_PROPERTYGET, VT_UNKNOWN, (void*)&result, NULL);
		return result;
	}
	void put_DataSourceEx(LPUNKNOWN newValue)
	{
		static BYTE parms[] = VTS_UNKNOWN ;
		InvokeHelper(0x21, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	LPDISPATCH get_RootBookmark()
	{
		LPDISPATCH result;
		InvokeHelper(0x22, DISPATCH_PROPERTYGET, VT_DISPATCH, (void*)&result, NULL);
		return result;
	}
	void ReachBookmark(LPCTSTR Bookmark)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x23, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Bookmark);
	}
	long get_Protected()
	{
		long result;
		InvokeHelper(0x25, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	long ReachText(long Option, LPCTSTR Text, LPCTSTR FontName, short FontSize, long Bold, long Italic)
	{
		long result;
		static BYTE parms[] = VTS_I4 VTS_BSTR VTS_BSTR VTS_I2 VTS_I4 VTS_I4 ;
		InvokeHelper(0x26, DISPATCH_METHOD, VT_I4, (void*)&result, parms, Option, Text, FontName, FontSize, Bold, Italic);
		return result;
	}
	void CreateObject(long ObjectType, LPCTSTR Reference)
	{
		static BYTE parms[] = VTS_I4 VTS_BSTR ;
		InvokeHelper(0x27, DISPATCH_METHOD, VT_EMPTY, NULL, parms, ObjectType, Reference);
	}
	long get_PageCount()
	{
		long result;
		InvokeHelper(0x28, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	long get_CurrentPage()
	{
		long result;
		InvokeHelper(0x29, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_CurrentPage(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x29, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	VARIANT get_ObjectAttribute(LPCTSTR Object, LPCTSTR Attribute)
	{
		VARIANT result;
		static BYTE parms[] = VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x2a, DISPATCH_PROPERTYGET, VT_VARIANT, (void*)&result, parms, Object, Attribute);
		return result;
	}
	void put_ObjectAttribute(LPCTSTR Object, LPCTSTR Attribute, VARIANT newValue)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_VARIANT ;
		InvokeHelper(0x2a, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, Object, Attribute, &newValue);
	}
	long get_Modified()
	{
		long result;
		InvokeHelper(0x2b, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_Modified(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x2b, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	CString get_DataTableOrView()
	{
		CString result;
		InvokeHelper(0x2c, DISPATCH_PROPERTYGET, VT_BSTR, (void*)&result, NULL);
		return result;
	}
	void put_DataTableOrView(LPCTSTR newValue)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x2c, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_Copies()
	{
		long result;
		InvokeHelper(0x2d, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_Copies(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x2d, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	short get_Duplex()
	{
		short result;
		InvokeHelper(0x2e, DISPATCH_PROPERTYGET, VT_I2, (void*)&result, NULL);
		return result;
	}
	void put_Duplex(short newValue)
	{
		static BYTE parms[] = VTS_I2 ;
		InvokeHelper(0x2e, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void AddPage(long PageIndex)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x2f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageIndex);
	}
	void Encrypt(LPCTSTR OwnerPassword, LPCTSTR UserPassword, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_I4 ;
		InvokeHelper(0x30, DISPATCH_METHOD, VT_EMPTY, NULL, parms, OwnerPassword, UserPassword, Options);
	}
	long get_Linearized()
	{
		long result;
		InvokeHelper(0x31, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_Linearized(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x31, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void ReceiveDoc(long lPort, long lTimeout)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x32, DISPATCH_METHOD, VT_EMPTY, NULL, parms, lPort, lTimeout);
	}
	void SendDoc(LPCTSTR szAddress, long lPort, LPCTSTR szUsername)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_BSTR ;
		InvokeHelper(0x33, DISPATCH_METHOD, VT_EMPTY, NULL, parms, szAddress, lPort, szUsername);
	}
	CString ReachTextEx(long Option, LPCTSTR Text, LPCTSTR FontName, short FontSize, long Bold, long Italic)
	{
		CString result;
		static BYTE parms[] = VTS_I4 VTS_BSTR VTS_BSTR VTS_I2 VTS_I4 VTS_I4 ;
		InvokeHelper(0x34, DISPATCH_METHOD, VT_BSTR, (void*)&result, parms, Option, Text, FontName, FontSize, Bold, Italic);
		return result;
	}
	void ObjectAttributeStr(LPCTSTR Object, LPCTSTR Attribute, LPCTSTR newVal)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x35, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object, Attribute, newVal);
	}
	long get_StatusBar()
	{
		long result;
		InvokeHelper(0x36, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_StatusBar(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x36, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	VARIANT get_SelectedObject()
	{
		VARIANT result;
		InvokeHelper(0x37, DISPATCH_PROPERTYGET, VT_VARIANT, (void*)&result, NULL);
		return result;
	}
	long get_PageWidth()
	{
		long result;
		InvokeHelper(0x38, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_PageWidth(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x38, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_PageLength()
	{
		long result;
		InvokeHelper(0x39, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_PageLength(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x39, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void DataReceived(unsigned char * data, long length)
	{
		static BYTE parms[] = VTS_PUI1 VTS_I4 ;
		InvokeHelper(0x3a, DISPATCH_METHOD, VT_EMPTY, NULL, parms, data, length);
	}
	void PageReceived()
	{
		InvokeHelper(0x3b, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	long get_VerticalNaviguationBar()
	{
		long result;
		InvokeHelper(0x3c, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_VerticalNaviguationBar(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x3c, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void StartPrint(LPCTSTR PrinterName, long Prompt)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x3d, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PrinterName, Prompt);
	}
	void PrintPage(long PageNumber)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x3e, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber);
	}
	void EndPrint()
	{
		InvokeHelper(0x3f, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	LPDISPATCH GetObjectXY(long X, long Y)
	{
		LPDISPATCH result;
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x40, DISPATCH_METHOD, VT_DISPATCH, (void*)&result, parms, X, Y);
		return result;
	}
	void ExportToHTML(LPCTSTR FileName, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x41, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options);
	}
	void ExportToRTF(LPCTSTR FileName, long Options, long UseTabs)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_I4 ;
		InvokeHelper(0x42, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options, UseTabs);
	}
	void ExportToJPeg(LPCTSTR FileName, long Resolution, long JPegLevel)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_I4 ;
		InvokeHelper(0x43, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Resolution, JPegLevel);
	}
	void ExportToXPS(LPCTSTR FileName, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x174, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options);
	}
	CString get_PrintToFileName()
	{
		CString result;
		InvokeHelper(0x44, DISPATCH_PROPERTYGET, VT_BSTR, (void*)&result, NULL);
		return result;
	}
	void put_PrintToFileName(LPCTSTR newValue)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x44, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void OptimizeDocument(long Level)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x45, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Level);
	}
	LPUNKNOWN get_ParentContainer()
	{
		LPUNKNOWN result;
		InvokeHelper(0x46, DISPATCH_PROPERTYGET, VT_UNKNOWN, (void*)&result, NULL);
		return result;
	}
	void put_ParentContainer(LPUNKNOWN newValue)
	{
		static BYTE parms[] = VTS_UNKNOWN ;
		InvokeHelper(0x46, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void EmbedFont(LPCTSTR BaseFont, long Option)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x47, DISPATCH_METHOD, VT_EMPTY, NULL, parms, BaseFont, Option);
	}
	void DrawCurrentPage(long hDC, long PrepareDC)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x48, DISPATCH_METHOD, VT_EMPTY, NULL, parms, hDC, PrepareDC);
	}
	void ActivateObject(LPCTSTR Object)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x49, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object);
	}
	long OpenEx(LPCTSTR FileName, LPCTSTR Password)
	{
		long result;
		static BYTE parms[] = VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x4a, DISPATCH_METHOD, VT_I4, (void*)&result, parms, FileName, Password);
		return result;
	}
	void SetLicenseKey(LPCTSTR Company, LPCTSTR LicKey)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x4b, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Company, LicKey);
	}
	void ExportToExcel(LPCTSTR FileName, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x4c, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options);
	}
	long get_ScaleToWindow()
	{
		long result;
		InvokeHelper(0x4d, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ScaleToWindow(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x4d, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_ScaleToPrinter()
	{
		long result;
		InvokeHelper(0x4e, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_ScaleToPrinter(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x4e, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	VARIANT get_Document()
	{
		VARIANT result;
		InvokeHelper(0x0, DISPATCH_PROPERTYGET, VT_VARIANT, (void*)&result, NULL);
		return result;
	}
	long get_SelectedObjectCount()
	{
		long result;
		InvokeHelper(0x4f, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	LPDISPATCH GetObjectByName(LPCTSTR Name)
	{
		LPDISPATCH result;
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x50, DISPATCH_METHOD, VT_DISPATCH, (void*)&result, parms, Name);
		return result;
	}
	void SetAttributeForMultipleSelection(LPCTSTR attribName, VARIANT attribVal)
	{
		static BYTE parms[] = VTS_BSTR VTS_VARIANT ;
		InvokeHelper(0x51, DISPATCH_METHOD, VT_EMPTY, NULL, parms, attribName, &attribVal);
	}
	void SelectAllObjects(long val)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x52, DISPATCH_METHOD, VT_EMPTY, NULL, parms, val);
	}
	void DuplicatePage(long PageIndex)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x53, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageIndex);
	}
	void DeletePage(long PageNumber, long CanUndo)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x54, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber, CanUndo);
	}
	void LockAllObjects(long Lock)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x55, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Lock);
	}
	void Append(LPCTSTR FileName, LPCTSTR Password)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR ;
		InvokeHelper(0x56, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Password);
	}
	void Merge(LPCTSTR FileName, LPCTSTR Password, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_I4 ;
		InvokeHelper(0x57, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Password, Options);
	}
	void AppendEx(LPDISPATCH Document)
	{
		static BYTE parms[] = VTS_DISPATCH ;
		InvokeHelper(0x58, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Document);
	}
	void MergeEx(LPDISPATCH Document, long Options)
	{
		static BYTE parms[] = VTS_DISPATCH VTS_I4 ;
		InvokeHelper(0x59, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Document, Options);
	}
	long get_ReadOnly()
	{
		long result;
		InvokeHelper(0x5a, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void SetPageNumbering(long Position, LPCTSTR Font, long ExtraMarginHorz, long ExtraMarginVert, long Color, long StartWithPage, LPCTSTR Format)
	{
		static BYTE parms[] = VTS_I4 VTS_BSTR VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_BSTR ;
		InvokeHelper(0x5b, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Position, Font, ExtraMarginHorz, ExtraMarginVert, Color, StartWithPage, Format);
	}
	long get_TemplateMode()
	{
		long result;
		InvokeHelper(0x5c, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_TemplateMode(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x5c, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_TemplateVisible()
	{
		long result;
		InvokeHelper(0x5d, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_TemplateVisible(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x5d, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_TemplatePrint()
	{
		long result;
		InvokeHelper(0x5e, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_TemplatePrint(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x5e, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_TemplateRepeat()
	{
		long result;
		InvokeHelper(0x5f, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_TemplateRepeat(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x5f, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	long get_WantTabs()
	{
		long result;
		InvokeHelper(0x60, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_WantTabs(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x60, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void StartSave(LPCTSTR FileName, long SaveOption)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x61, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, SaveOption);
	}
	void SavePage(long PageNumber)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x62, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber);
	}
	void EndSave()
	{
		InvokeHelper(0x63, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void ClearPage(long PageNumber)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x64, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber);
	}
	void Encrypt128(LPCTSTR OwnerPassword, LPCTSTR UserPassword, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_I4 ;
		InvokeHelper(0x65, DISPATCH_METHOD, VT_EMPTY, NULL, parms, OwnerPassword, UserPassword, Options);
	}
	long GetWarningLevel()
	{
		long result;
		InvokeHelper(0x66, DISPATCH_METHOD, VT_I4, (void*)&result, NULL);
		return result;
	}
	void ProcessHyperlinksBookmarksFromIniFile(LPCTSTR iniFileName)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x67, DISPATCH_METHOD, VT_EMPTY, NULL, parms, iniFileName);
	}
	void AutoHyperlinks(LPCTSTR prefixes)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x68, DISPATCH_METHOD, VT_EMPTY, NULL, parms, prefixes);
	}
	void AutoBookmarks(long levels, LPCTSTR fonts, long startPage)
	{
		static BYTE parms[] = VTS_I4 VTS_BSTR VTS_I4 ;
		InvokeHelper(0x69, DISPATCH_METHOD, VT_EMPTY, NULL, parms, levels, fonts, startPage);
	}
	long get_RulerBackColor()
	{
		long result;
		InvokeHelper(0x6a, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_RulerBackColor(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x6a, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void ExportToTiff(LPCTSTR FileName, long Resolution, long TiffFormat)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_I4 ;
		InvokeHelper(0x6b, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Resolution, TiffFormat);
	}
	void RotatePage(long PageNumber, long Rotation)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x6c, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber, Rotation);
	}
	void MovePages(long PageNumber, long PageCount, long Destination)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x6d, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber, PageCount, Destination);
	}
	void AddExternalObjectTemplate(LPDISPATCH externalObject)
	{
		static BYTE parms[] = VTS_DISPATCH ;
		InvokeHelper(0xc8, DISPATCH_METHOD, VT_EMPTY, NULL, parms, externalObject);
	}
	void CreateObjectEx(long ObjectType, LPCTSTR Reference, long subType, long PageNumber, BSTR * givenName)
	{
		static BYTE parms[] = VTS_I4 VTS_BSTR VTS_I4 VTS_I4 VTS_PBSTR ;
		InvokeHelper(0xc9, DISPATCH_METHOD, VT_EMPTY, NULL, parms, ObjectType, Reference, subType, PageNumber, givenName);
	}
	VARIANT GetObjectsInRectangle(long left, long top, long right, long bottom, long flags)
	{
		VARIANT result;
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0xca, DISPATCH_METHOD, VT_VARIANT, (void*)&result, parms, left, top, right, bottom, flags);
		return result;
	}
	void SetTargetDevmode(long hDevMode)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0xcb, DISPATCH_METHOD, VT_EMPTY, NULL, parms, hDevMode);
	}
	void PrinterSetup()
	{
		InvokeHelper(0xcc, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void DigitalSignature(LPCTSTR SignerName, LPCTSTR Reason, LPCTSTR ImageFile, LPCTSTR Location, long PageNumber, long HorzPos, long VertPos, long width, long height, long flags)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_BSTR VTS_BSTR VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0xcd, DISPATCH_METHOD, VT_EMPTY, NULL, parms, SignerName, Reason, ImageFile, Location, PageNumber, HorzPos, VertPos, width, height, flags);
	}
	void GetFontAttributes(LPCTSTR FontName, long * FontDescent, long * FontAscent)
	{
		static BYTE parms[] = VTS_BSTR VTS_PI4 VTS_PI4 ;
		InvokeHelper(0xce, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FontName, FontDescent, FontAscent);
	}
	void SetAttributeForMultipleSelectionEx(LPCTSTR attribName, VARIANT attribVal, long CanUndo)
	{
		static BYTE parms[] = VTS_BSTR VTS_VARIANT VTS_I4 ;
		InvokeHelper(0x12c, DISPATCH_METHOD, VT_EMPTY, NULL, parms, attribName, &attribVal, CanUndo);
	}
	long get_RefreshEventReason()
	{
		long result;
		InvokeHelper(0x12d, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void SetRefreshEventReason(long newVal, long bAddToExistingReason)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x12e, DISPATCH_METHOD, VT_EMPTY, NULL, parms, newVal, bAddToExistingReason);
	}
	void SetToolTipText(LPCTSTR tooltipText)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x12f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, tooltipText);
	}
	LPUNKNOWN NewPluginBaseObject()
	{
		LPUNKNOWN result;
		InvokeHelper(0x130, DISPATCH_METHOD, VT_UNKNOWN, (void*)&result, NULL);
		return result;
	}
	void GetPlugin(long PluginID, long bOnlyIfLoaded, LPUNKNOWN * ppUnknown)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_PUNKNOWN ;
		InvokeHelper(0x132, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PluginID, bOnlyIfLoaded, ppUnknown);
	}
	long StartSaveEx(LPCTSTR FileName, long SaveOption)
	{
		long result;
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x15e, DISPATCH_METHOD, VT_I4, (void*)&result, parms, FileName, SaveOption);
		return result;
	}
	void SavePageEx(long Handle, long PageNumber)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x15f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Handle, PageNumber);
	}
	void EndSaveEx(long Handle)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x160, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Handle);
	}
	void DeleteAllHyperlinks()
	{
		InvokeHelper(0x168, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	VARIANT GetPageText(long PageNumber)
	{
		VARIANT result;
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x169, DISPATCH_METHOD, VT_VARIANT, (void*)&result, parms, PageNumber);
		return result;
	}
	CString GetRawPageText(long PageNumber)
	{
		CString result;
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x16a, DISPATCH_METHOD, VT_BSTR, (void*)&result, parms, PageNumber);
		return result;
	}
	void ExportToHTMLEx(LPCTSTR FileName, long Options, LPCTSTR imageNamingInfo, long downsamplingResolution)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_BSTR VTS_I4 ;
		InvokeHelper(0x172, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options, imageNamingInfo, downsamplingResolution);
	}
	void AutoHyperlinksEx(LPCTSTR prefixes, long ClearExistingHyperlinks)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x173, DISPATCH_METHOD, VT_EMPTY, NULL, parms, prefixes, ClearExistingHyperlinks);
	}
	CString get_OptionalRegistryKeyForSavingSettings()
	{
		CString result;
		InvokeHelper(0x17c, DISPATCH_PROPERTYGET, VT_BSTR, (void*)&result, NULL);
		return result;
	}
	void put_OptionalRegistryKeyForSavingSettings(LPCTSTR newValue)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x17c, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void GetScreenCoordinates(LPCTSTR objectName, long * left, long * top, long * right, long * bottom)
	{
		static BYTE parms[] = VTS_BSTR VTS_PI4 VTS_PI4 VTS_PI4 VTS_PI4 ;
		InvokeHelper(0x17d, DISPATCH_METHOD, VT_EMPTY, NULL, parms, objectName, left, top, right, bottom);
	}
	void Split(LPCTSTR OutputFile)
	{
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x17e, DISPATCH_METHOD, VT_EMPTY, NULL, parms, OutputFile);
	}
	void SplitXY(LPCTSTR OutputFile, long xPos, long yPos)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 VTS_I4 ;
		InvokeHelper(0x17f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, OutputFile, xPos, yPos);
	}
	void ObjectAttributeLong(LPCTSTR Object, LPCTSTR Attribute, long newVal)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_I4 ;
		InvokeHelper(0x181, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object, Attribute, newVal);
	}
	void ObjectAttributeFloat(LPCTSTR Object, LPCTSTR Attribute, float newVal)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_R4 ;
		InvokeHelper(0x182, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Object, Attribute, newVal);
	}
	void AddLayer(LPCTSTR displayName, BSTR * newLayerID)
	{
		static BYTE parms[] = VTS_BSTR VTS_PBSTR ;
		InvokeHelper(0x183, DISPATCH_METHOD, VT_EMPTY, NULL, parms, displayName, newLayerID);
	}
	void AddLayerConfiguration(BSTR * configID)
	{
		static BYTE parms[] = VTS_PBSTR ;
		InvokeHelper(0x184, DISPATCH_METHOD, VT_EMPTY, NULL, parms, configID);
	}
	void GetVersionInfo(VARIANT * ProductMajor, VARIANT * ProductMinor, VARIANT * FileMajor, VARIANT * FileMinor)
	{
		static BYTE parms[] = VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT ;
		InvokeHelper(0x190, DISPATCH_METHOD, VT_EMPTY, NULL, parms, ProductMajor, ProductMinor, FileMajor, FileMinor);
	}
	long GetSentenceCount(long PageNumber)
	{
		long result;
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x191, DISPATCH_METHOD, VT_I4, (void*)&result, parms, PageNumber);
		return result;
	}
	CString GetSentence(long PageNumber, long sentenceNumber)
	{
		CString result;
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x192, DISPATCH_METHOD, VT_BSTR, (void*)&result, parms, PageNumber, sentenceNumber);
		return result;
	}
	long HighlightWordInSentence(long PageNumber, long sentenceNumber, long wordNumber, long highlightColor)
	{
		long result;
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x193, DISPATCH_METHOD, VT_I4, (void*)&result, parms, PageNumber, sentenceNumber, wordNumber, highlightColor);
		return result;
	}
	LPDISPATCH GetPDFDocumentInterface()
	{
		LPDISPATCH result;
		InvokeHelper(0x194, DISPATCH_METHOD, VT_DISPATCH, (void*)&result, NULL);
		return result;
	}
	void GetLicenseKey(BSTR * Company, BSTR * LicKey)
	{
		static BYTE parms[] = VTS_PBSTR VTS_PBSTR ;
		InvokeHelper(0x195, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Company, LicKey);
	}
	void DeleteAllBookmarks()
	{
		InvokeHelper(0x196, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void DeleteAllLayers()
	{
		InvokeHelper(0x197, DISPATCH_METHOD, VT_EMPTY, NULL, NULL);
	}
	void OptimizeDocumentEx(long Level, long PageNumber)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x198, DISPATCH_METHOD, VT_EMPTY, NULL, parms, Level, PageNumber);
	}
	void DrawCurrentPageEx(long hDC, long PrepareDC, long zoomLevel)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x199, DISPATCH_METHOD, VT_EMPTY, NULL, parms, hDC, PrepareDC, zoomLevel);
	}
	LPDISPATCH GetFontByName(LPCTSTR FontName)
	{
		LPDISPATCH result;
		static BYTE parms[] = VTS_BSTR ;
		InvokeHelper(0x19a, DISPATCH_METHOD, VT_DISPATCH, (void*)&result, parms, FontName);
		return result;
	}
	long get_UsePropertiesDialog()
	{
		long result;
		InvokeHelper(0x19b, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_UsePropertiesDialog(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x19b, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void ShowFieldsOnVirtualPage(long show)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x19c, DISPATCH_METHOD, VT_EMPTY, NULL, parms, show);
	}
	void DrawCurrentPageToMetaFile(LPCTSTR metaFile, long zoomLevel)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x19d, DISPATCH_METHOD, VT_EMPTY, NULL, parms, metaFile, zoomLevel);
	}
	void SaveObjects(LPUNKNOWN pstm)
	{
		static BYTE parms[] = VTS_UNKNOWN ;
		InvokeHelper(0x19f, DISPATCH_METHOD, VT_EMPTY, NULL, parms, pstm);
	}
	void InsertObjects(LPUNKNOWN pstm)
	{
		static BYTE parms[] = VTS_UNKNOWN ;
		InvokeHelper(0x1a0, DISPATCH_METHOD, VT_EMPTY, NULL, parms, pstm);
	}
	void OCRPageRange(long startPage, long EndPage, LPCTSTR Language, long Options)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_BSTR VTS_I4 ;
		InvokeHelper(0x1a1, DISPATCH_METHOD, VT_EMPTY, NULL, parms, startPage, EndPage, Language, Options);
	}
	void RasterizePageRange(long startPage, long EndPage, long Resolution, long colorOption, long compression)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x1a2, DISPATCH_METHOD, VT_EMPTY, NULL, parms, startPage, EndPage, Resolution, colorOption, compression);
	}
	void Encrypt256(LPCTSTR OwnerPassword, LPCTSTR UserPassword, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_BSTR VTS_I4 ;
		InvokeHelper(0x1a3, DISPATCH_METHOD, VT_EMPTY, NULL, parms, OwnerPassword, UserPassword, Options);
	}
	CString GetVersionInfo2()
	{
		CString result;
		InvokeHelper(0x1a4, DISPATCH_METHOD, VT_BSTR, (void*)&result, NULL);
		return result;
	}
	void ScalePageContents(long PageNumber, long ScaleFactor, long Options)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x1a5, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber, ScaleFactor, Options);
	}
	void FlattenPageContents(long PageNumber, long Resolution)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 ;
		InvokeHelper(0x1a6, DISPATCH_METHOD, VT_EMPTY, NULL, parms, PageNumber, Resolution);
	}
	long get_VerticalNavigationBar()
	{
		long result;
		InvokeHelper(0x1a7, DISPATCH_PROPERTYGET, VT_I4, (void*)&result, NULL);
		return result;
	}
	void put_VerticalNavigationBar(long newValue)
	{
		static BYTE parms[] = VTS_I4 ;
		InvokeHelper(0x1a7, DISPATCH_PROPERTYPUT, VT_EMPTY, NULL, parms, newValue);
	}
	void AppendEx2(LPUNKNOWN pStream)
	{
		static BYTE parms[] = VTS_UNKNOWN ;
		InvokeHelper(0x1a8, DISPATCH_METHOD, VT_EMPTY, NULL, parms, pStream);
	}
	void MergeEx2(LPUNKNOWN pStream, long Options)
	{
		static BYTE parms[] = VTS_UNKNOWN VTS_I4 ;
		InvokeHelper(0x1a9, DISPATCH_METHOD, VT_EMPTY, NULL, parms, pStream, Options);
	}
	void DrawCurrentPageRT(LPUNKNOWN pID2D1RenderTarget, long scrollX, long scrollY)
	{
		static BYTE parms[] = VTS_UNKNOWN VTS_I4 VTS_I4 ;
		InvokeHelper(0x1aa, DISPATCH_METHOD, VT_EMPTY, NULL, parms, pID2D1RenderTarget, scrollX, scrollY);
	}
	void ExportToHTML5(LPCTSTR FileName, long Options)
	{
		static BYTE parms[] = VTS_BSTR VTS_I4 ;
		InvokeHelper(0x1ab, DISPATCH_METHOD, VT_EMPTY, NULL, parms, FileName, Options);
	}
	void ExportToHTML5Ex(LPUNKNOWN stream, long Options, LPCTSTR imageNamingInfo)
	{
		static BYTE parms[] = VTS_UNKNOWN VTS_I4 VTS_BSTR ;
		InvokeHelper(0x1ac, DISPATCH_METHOD, VT_EMPTY, NULL, parms, stream, Options, imageNamingInfo);
	}
	void Redact(long left, long top, long right, long bottom, long Options, long redactionColor)
	{
		static BYTE parms[] = VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 ;
		InvokeHelper(0x1ad, DISPATCH_METHOD, VT_EMPTY, NULL, parms, left, top, right, bottom, Options, redactionColor);
	}


};
